/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.executable_spec;

import ca.ntro.app.tasks.SimpleTaskCreator;
import ca.ntro.app.tasks.SubTasksLambda;
import ca.ntro.app.tasks.TaskGroupCreator;
import ca.ntro.ntro_app_fx_impl.executable_spec.TaskSpec;
import ca.ntro.ntro_app_fx_impl.tasks.SimpleTaskDescriptor;
import ca.ntro.ntro_app_fx_impl.tasks.TaskDescriptor;
import ca.ntro.ntro_app_fx_impl.tasks.TaskFactory;
import ca.ntro.ntro_app_fx_impl.tasks.TaskGroupDescriptor;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.exceptions.InvalidCharacterException;
import ca.ntro.ntro_core_impl.identifyers.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TaskGroupSpec<TASKS>
extends TaskSpec
implements TaskGroupCreator {
    private List<String> taskCreationOrder = new ArrayList<String>();
    private Map<String, TaskSpec> simpleTasks = new HashMap<String, TaskSpec>();
    private Map<String, TaskGroupSpec> taskGroups = new HashMap<String, TaskGroupSpec>();
    private transient Map<String, TaskDescriptor> descriptors = new HashMap<String, TaskDescriptor>();

    protected abstract TaskGroupSpec newTaskGroup();

    protected <O> SimpleTaskCreator<O> createTask(String taskId) {
        try {
            Key.mustBeValidKey((String)taskId);
        }
        catch (InvalidCharacterException e) {
            NtroCoreImpl.logger().fatal("taskId must be a valid Java identifyer\n\n\t\t'" + taskId + "' is not valid");
        }
        TaskSpec task = new TaskSpec();
        this.taskCreationOrder.add(taskId);
        this.simpleTasks.put(taskId, task);
        return task;
    }

    protected <O> SimpleTaskCreator<O> createTask(SimpleTaskDescriptor<O> descriptor) {
        TaskSpec task = new TaskSpec();
        String taskId = descriptor.id();
        this.descriptors.put(taskId, descriptor);
        this.taskCreationOrder.add(taskId);
        this.simpleTasks.put(taskId, task);
        return task;
    }

    protected <O> TaskGroupCreator<O, TASKS> createTaskGroup(String taskGroupId) {
        try {
            Key.mustBeValidKey((String)taskGroupId);
        }
        catch (InvalidCharacterException e) {
            NtroCoreImpl.logger().fatal("taskId must be a valid Java identifyer\n\n\t\t'" + taskGroupId + "' is not valid");
        }
        TaskGroupSpec taskGroup = this.newTaskGroup();
        this.taskCreationOrder.add(taskGroupId);
        this.taskGroups.put(taskGroupId, taskGroup);
        return taskGroup;
    }

    protected <O> TaskGroupCreator<O, TASKS> createTaskGroup(TaskGroupDescriptor<O> descriptor) {
        TaskGroupSpec taskGroup = this.newTaskGroup();
        String taskGroupId = descriptor.id();
        this.descriptors.put(taskGroupId, descriptor);
        this.taskCreationOrder.add(taskGroupId);
        this.taskGroups.put(taskGroupId, taskGroup);
        return taskGroup;
    }

    public TaskGroupCreator contains(SubTasksLambda subTasksLambda) {
        subTasksLambda.createSubTasks(this);
        return this;
    }

    public void createSubTasks(TaskFactory taskFactory) {
        for (String taskId : this.taskCreationOrder) {
            TaskSpec task = this.simpleTasks.get(taskId);
            if (task != null) {
                TaskDescriptor descriptor = this.descriptors.get(taskId);
                SimpleTaskCreator<Object> taskCreator = null;
                taskCreator = descriptor != null ? taskFactory.task((SimpleTaskDescriptor)descriptor) : taskFactory.task(taskId);
                task.addWaitsFors(taskCreator);
                task.addExecutor(taskCreator);
                continue;
            }
            task = this.taskGroups.get(taskId);
            if (task == null) continue;
            TaskGroupSpec taskGroup = (TaskGroupSpec)task;
            TaskDescriptor descriptor = this.descriptors.get(taskId);
            TaskGroupCreator taskGroupCreator = null;
            taskGroupCreator = descriptor != null ? taskFactory.taskGroup((TaskGroupDescriptor)descriptor) : taskFactory.taskGroup(taskId);
            taskGroup.addWaitsFors(taskGroupCreator);
            taskGroupCreator.contains((TASKS subTasks) -> taskGroup.createSubTasks((TaskFactory)subTasks));
        }
    }
}

