/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl;

import ca.ntro.app.NtroClientFx;
import ca.ntro.ntro_app_fx_impl.AppWrapperFx;
import ca.ntro.ntro_app_fx_impl.NtroExecutableImpl;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.NtroMode;
import ca.ntro.ntro_app_fx_impl.executable_spec.ClientFxSpec;
import ca.ntro.ntro_app_fx_impl.executable_spec.ExecutableSpec;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.services.StackAnalyzerImpl;
import java.util.Map;
import javafx.application.Application;

public class NtroClientFxImpl
extends NtroExecutableImpl<NtroClientFx, ClientFxSpec> {
    private static final NtroClientFxImpl instance = new NtroClientFxImpl();
    private String sessionId;

    public static NtroClientFxImpl instance() {
        return instance;
    }

    public void loadSession(String filePath) {
        this.initializeIfNeeded();
        this.failIfAlreadyLaunched("loadSession");
    }

    @Override
    protected void initializeWithParams(Map<String, String> params) {
        if (params.containsKey("session")) {
            this.sessionId = params.get("session");
        }
    }

    @Override
    protected void launchImpl(Class<? extends NtroClientFx> clientClass, ClientFxSpec spec) {
        AppWrapperFx.sessionId = this.sessionId;
        AppWrapperFx.appClass = clientClass;
        AppWrapperFx.spec = spec;
        ((StackAnalyzerImpl)NtroCoreImpl.stackAnalyzer()).registerAppWrapperClass(AppWrapperFx.class);
        try {
            Application.launch(AppWrapperFx.class, (String[])new String[0]);
        }
        catch (Throwable t) {
            NtroCoreImpl.logger().fatal(t);
        }
    }

    @Override
    protected void initializeNtroMode() {
        NtroImpl.registerNtroMode(NtroMode.CLIENT);
    }

    @Override
    protected ExecutableSpec createEmptySpec() {
        return new ClientFxSpec();
    }
}

