package depart.frontal.taches;

import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.vues.VueA;

import static ca.ntro.app.tasks.frontend.FrontendTasks.*;

public class TachesB {
    
    public static void creerTaches(FrontendTasks tasks) {
        
        tasks.taskGroup("TachesB")
        
             .waitsFor("TachesA")
        
             .contains(subTasks -> {

                tacheB1(subTasks);

                tacheB2(subTasks);

             });
    }

    private static void tacheB1(FrontendTasks subTasks) {

        subTasks.task("tacheB1")
        
              .waitsFor(window())
              
              .waitsFor(created(VueA.class))
              
              .executes(inputs -> {
                  
                  var objA  = inputs.get(created(VueA.class));
                  var objB  = inputs.get(window());

                  objB.installRootView(objA);
              });
    }

    private static void tacheB2(FrontendTasks tasks) {

        tasks.task("tacheB2")

             .waitsFor(window())

             .executes(inputs -> {

                 var objA = inputs.get(window());

                 objA.resize(650,720);

                 objA.show();

             });
    }

}
