package depart.frontal;

import ca.ntro.app.Ntro;
import ca.ntro.app.events.EventRegistrar;
import ca.ntro.app.frontend.FrontendFx;
import ca.ntro.app.frontend.ViewRegistrarFx;
import ca.ntro.app.session.SessionRegistrar;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import depart.frontal.taches.TachesA;
import depart.frontal.taches.TachesB;
import depart.frontal.vues.VueA;

public class FrontalDepart implements FrontendFx {

	@Override
	public void registerEvents(EventRegistrar registrar) {
		
	}

	@Override
	public void registerViews(ViewRegistrarFx registrar) {
		registrar.registerDefaultLocale(Ntro.buildLocale("fr"));
		registrar.registerTranslations(Ntro.buildLocale("fr"), "/traductions/fr.properties");
		registrar.registerTranslations(Ntro.buildLocale("en"), "/traductions/en.properties");

		registrar.registerView(VueA.class, "/vues/vue_a.fxml");

		registrar.registerStylesheet("/style/dev.css");
	}

	@Override
	public void registerSessionClass(SessionRegistrar registrar) {
		
	}

	@Override
	public void createTasks(FrontendTasks tasks) {
		TachesA.creerTaches(tasks);
		TachesB.creerTaches(tasks);
	}

}
