/*
Copyright (C) (2020) (Mathieu Bergeron) (mathieu.bergeron@cmontmorency.qc.ca)

This file is part of Ntro, an application framework designed with teaching in mind.

This is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/
package ca.ntro.core.services;

import java.util.List;

public interface RandomService {

	public static final int DEFAULT_ID_SIZE = 4;
	
	boolean nextBoolean();
	
	int nextInt();
	int nextInt(int bound);

	double nextDouble();
	double nextDouble(double bound);
	
	<V> V choice(List<V> list);
	<V> V choice(V[] array);

	String nextId();
	String nextId(int size);

}
