/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.frontend;

import ca.ntro.app.Ntro;
import ca.ntro.app.frontend.Frontend;
import ca.ntro.app.services.Window;
import ca.ntro.app.session.Session;
import ca.ntro.app.session.SessionAccessor;
import ca.ntro.app.tasks.frontend.FrontendTasks;
import ca.ntro.ntro_app_fx_impl.frontend.EventRegistrarNtro;
import ca.ntro.ntro_app_fx_impl.frontend.FrontendExecutor;
import ca.ntro.ntro_app_fx_impl.frontend.FrontendRegistrar;
import ca.ntro.ntro_app_fx_impl.frontend.ViewRegistrar;
import ca.ntro.ntro_app_fx_impl.frontend.WindowNull;
import ca.ntro.ntro_app_fx_impl.messages.MessageRegistrarNtro;
import ca.ntro.ntro_app_fx_impl.models.ModelRegistrarImpl;
import ca.ntro.ntro_app_fx_impl.session.SessionRegistrarImpl;
import ca.ntro.ntro_app_fx_impl.tasks.frontend.FrontendTaskFactory;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.task_graphs.generic_task_graph.SimpleTaskOptions;
import ca.ntro.ntro_core_impl.task_graphs.task_graph.ExecutableTaskNtro;
import ca.ntro.ntro_core_impl.task_graphs.task_graph_trace.TaskResultsCondition;
import ca.ntro.ntro_core_impl.task_graphs.task_graph_trace.TaskTraceNtro;

public abstract class FrontendRegistrarImpl<VR extends ViewRegistrar>
implements FrontendRegistrar<VR>,
FrontendExecutor {
    private EventRegistrarNtro eventRegistrar = new EventRegistrarNtro();
    private SessionRegistrarImpl sessionRegistrar = new SessionRegistrarImpl();
    private FrontendTaskFactory taskFactory = new FrontendTaskFactory();
    private VR viewRegistrar = this.newViewRegistrarInstance();
    private Window window = new WindowNull();
    private Frontend<VR> frontend = null;
    private MessageRegistrarNtro messageRegistrar;
    private ModelRegistrarImpl modelRegistrar;
    private String sessionId;

    public EventRegistrarNtro getEventRegistrar() {
        return this.eventRegistrar;
    }

    public void setEventRegistrar(EventRegistrarNtro eventRegistrar) {
        this.eventRegistrar = eventRegistrar;
    }

    public Window getWindow() {
        return this.window;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public SessionRegistrarImpl getSessionRegistrar() {
        return this.sessionRegistrar;
    }

    public void setSessionRegistrar(SessionRegistrarImpl sessionRegistrar) {
        this.sessionRegistrar = sessionRegistrar;
    }

    public FrontendTaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    public void setTaskFactory(FrontendTaskFactory taskCreator) {
        this.taskFactory = taskCreator;
    }

    public VR getViewRegistrar() {
        return this.viewRegistrar;
    }

    public void setViewRegistrar(VR viewRegistrar) {
        this.viewRegistrar = viewRegistrar;
    }

    public Frontend<VR> getFrontend() {
        return this.frontend;
    }

    public void setFrontend(Frontend<VR> frontend) {
        this.frontend = frontend;
    }

    public MessageRegistrarNtro getMessageRegistrar() {
        return this.messageRegistrar;
    }

    public void setMessageRegistrar(MessageRegistrarNtro messageRegistrar) {
        this.messageRegistrar = messageRegistrar;
    }

    public ModelRegistrarImpl getModelRegistrar() {
        return this.modelRegistrar;
    }

    public void setModelRegistrar(ModelRegistrarImpl modelRegistrar) {
        this.modelRegistrar = modelRegistrar;
    }

    protected abstract VR newViewRegistrarInstance();

    @Override
    public void registerFrontend(Class<? extends Frontend<VR>> frontendClass) {
        Frontend frontend = (Frontend)NtroCoreImpl.factory().newInstance(frontendClass);
        this.registerFrontendObject(frontend);
    }

    public void registerFrontendObject(Frontend<VR> frontend) {
        this.frontend = frontend;
        frontend.registerEvents(this.getEventRegistrar());
        frontend.registerViews(this.getViewRegistrar());
        this.addWindowTask();
        this.getEventRegistrar().addEventHandlerTasks(this.getTaskFactory());
        this.createRegisteredSession(this.sessionId);
        frontend.createTasks(this.getTaskFactory().asTasks());
    }

    private void addWindowTask() {
        this.getTaskFactory().orphanTask(FrontendTasks.window(), (SimpleTaskOptions)SimpleTaskOptions.taskClass(ExecutableTaskNtro.class).traceClass(TaskTraceNtro.class).resultsClass(TaskResultsCondition.class)).executesAndReturnsValue(inputs -> this.getWindow());
    }

    public void prepareToExecuteTasks() {
        this.getTaskFactory().prepareToExecuteTasks();
        this.getTaskFactory().registerTaskTrace();
    }

    public void createRegisteredSession(String sessionId) {
        if (this.frontend != null) {
            this.frontend.registerSessionClass(this.getSessionRegistrar());
        }
        this.getSessionRegistrar().createRegisteredSession(sessionId);
        this.getSessionRegistrar().addSessionTask(this.getTaskFactory());
        Object session = Ntro.session();
        if (SessionAccessor.isNamedSession(session)) {
            Ntro.logger().info("session: " + ((Session)session).sessionId());
        } else {
            Ntro.logger().info("anonymous session (" + ((Session)session).sessionId() + ")");
        }
    }

    public void writeGraph() {
        if (this.getTaskFactory() != null) {
            this.getTaskFactory().writeGraph();
        }
    }

    @Override
    public void executeTasks() {
        this.getTaskFactory().executeTasks();
    }

    public boolean isFrontendRegistered() {
        return this.frontend != null;
    }

    public void registerSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

