/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.executable_spec;

import ca.ntro.app.Ntro;
import ca.ntro.app.NtroClientFx;
import ca.ntro.app.frontend.Frontend;
import ca.ntro.app.frontend.FrontendRegistrarFx;
import ca.ntro.app.frontend.View;
import ca.ntro.app.frontend.ViewRegistrarFx;
import ca.ntro.core.NtroCore;
import ca.ntro.core.util.StringUtils;
import ca.ntro.ntro_app_fx_impl.executable_spec.ClientSpec;
import ca.ntro.ntro_app_fx_impl.executable_spec.ViewSpecFx;
import ca.ntro.ntro_app_fx_impl.frontend.ViewRegistrarFxImpl;
import ca.ntro.ntro_app_fx_impl.tasks.frontend.FrontendTaskFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientFxSpec<APP extends NtroClientFx>
extends ClientSpec<APP>
implements FrontendRegistrarFx,
ViewRegistrarFx {
    private String cssPath = null;
    private transient long cssLastModified = 0L;
    private transient ViewRegistrarFxImpl viewRegistrarFx = new ViewRegistrarFxImpl();
    private transient Consumer<Frontend> frontendInitializer = null;
    private static final Pattern FX_CONTROLLER_RE = Pattern.compile("fx:controller\\s*=\\s*[\"']([^\"']+)[\"']");

    @Override
    protected void registerViews(Frontend<?> frontendObject) {
        frontendObject.registerViews(this);
    }

    @Override
    protected void addViewLoaderTasks(FrontendTaskFactory frontendTaskFactory) {
        this.viewRegistrarFx.registerDefaultLocale(this.getDefaultLocale());
        if (this.cssPath != null) {
            this.viewRegistrarFx.registerStylesheet(this.cssPath);
        }
        this.forEachTranslation((lang, resourcePath) -> this.viewRegistrarFx.registerTranslations(Ntro.buildLocale(lang), (String)resourcePath));
        this.forEachView(viewSpec -> {
            if (viewSpec instanceof ViewSpecFx) {
                ((ViewSpecFx)viewSpec).registerView(this.viewRegistrarFx);
            }
        });
        this.viewRegistrarFx.addViewLoaderTasks(frontendTaskFactory);
    }

    @Override
    protected void callExectuableCodeAndFillSpec(APP app) {
        super.callExectuableCodeAndFillSpec(app);
        app.registerFrontend((ClientFxSpec)this);
    }

    @Override
    public <V extends View<?>> void registerView(Class<V> viewClass, String fxmlPath) {
        String viewName = viewClass.getSimpleName();
        this.addViewSpec(viewName, new ViewSpecFx(viewClass, fxmlPath));
    }

    @Override
    public <V extends View<?>> void registerFragment(Class<V> fragmentClass, String fxmlPath) {
        String fragmentName = fragmentClass.getSimpleName();
        this.addViewSpec(fragmentName, new ViewSpecFx(fragmentClass, fxmlPath));
    }

    @Override
    public void registerStylesheet(String cssPath) {
        this.cssPath = cssPath;
    }

    @Override
    protected void analyzeProjectResourceFile(File resourcesRootDir, File file, String basename, String ext) {
        String[] segments;
        super.analyzeProjectResourceFile(resourcesRootDir, file, basename, ext);
        if (ext.equalsIgnoreCase("css")) {
            if (file.lastModified() > this.cssLastModified) {
                Path resourcePath = resourcesRootDir.toPath().relativize(file.toPath());
                String resourcePathRaw = StringUtils.windowsPathToUnix((String)resourcePath.toString());
                this.registerStylesheet("/" + resourcePathRaw);
                this.cssLastModified = file.lastModified();
            }
        } else if (ext.equalsIgnoreCase("fxml") || ext.equalsIgnoreCase("xml")) {
            try {
                Scanner fileScanner = new Scanner(new FileInputStream(file));
                int lineNum = 1;
                while (fileScanner.hasNextLine()) {
                    String line = fileScanner.nextLine();
                    Matcher matcher = FX_CONTROLLER_RE.matcher(line);
                    boolean found = matcher.find();
                    if (found) {
                        String classFullname = matcher.group(1);
                        try {
                            Class<?> _class = Class.forName(classFullname);
                            Path resourcePath = resourcesRootDir.toPath().relativize(file.toPath());
                            String resourcePathRaw = StringUtils.windowsPathToUnix((String)resourcePath.toString());
                            this.registerView(_class, "/" + resourcePathRaw);
                        }
                        catch (ClassNotFoundException e) {
                            NtroCore.logger().fatal("(" + basename + "." + ext + ":" + lineNum + ") fx:controller class not found: " + classFullname);
                        }
                    }
                    ++lineNum;
                }
            }
            catch (FileNotFoundException e) {
                NtroCore.logger().warning("cannot load file: " + String.valueOf(file));
            }
        } else if (ext.equalsIgnoreCase("properties") && (segments = basename.split("\\.")).length > 0) {
            String lang = segments[segments.length - 1];
            Path resourcePath = resourcesRootDir.toPath().relativize(file.toPath());
            String resourcePathRaw = StringUtils.windowsPathToUnix((String)resourcePath.toString());
            this.registerTranslations(Ntro.locale().buildLocale(lang), "/" + resourcePathRaw);
        }
    }

    @Override
    public <F extends Frontend> void initializeFrontendObject(Class<F> frontendClass, Consumer<F> frontendInitializer) {
        this.frontendInitializer = frontendInitializer;
    }

    @Override
    protected void additionnalFrontendInitialization(Frontend frontendObject) {
        if (this.frontendInitializer != null) {
            this.frontendInitializer.accept(frontendObject);
        }
    }

    @Override
    public void registerFrontend(Class<? extends Frontend<ViewRegistrarFx>> frontendClass) {
        this.registerFrontendImpl(frontendClass);
    }

    @Override
    protected void callRegisterFrontend(APP app) {
        app.registerFrontend((ClientFxSpec)this);
    }
}

