/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.backend;

import ca.ntro.app.Ntro;
import ca.ntro.app.session.Session;
import ca.ntro.core.NtroCore;
import ca.ntro.ntro_app_fx_abstr.messages.MessageAbstr;
import ca.ntro.ntro_app_fx_impl.NtroImpl;
import ca.ntro.ntro_app_fx_impl.backend.MessageFromServerHandlerNull;
import ca.ntro.ntro_app_fx_impl.backend.ObservationFromServerHandlerNull;
import ca.ntro.ntro_app_fx_impl.messages.BroadcastMessageImpl;
import ca.ntro.ntro_app_fx_impl.messages.DeliveryMode;
import ca.ntro.ntro_app_fx_impl.messages.MessageFromServerHandler;
import ca.ntro.ntro_app_fx_impl.messages.MessageServer;
import ca.ntro.ntro_app_fx_impl.messages.ObservationFromServerHandler;
import ca.ntro.ntro_app_fx_impl.messages.RegisterSessionImpl;
import ca.ntro.ntro_app_fx_impl.messages.RequestFirstObservationImpl;
import ca.ntro.ntro_app_fx_impl.modified.Observable;
import ca.ntro.ntro_app_fx_impl.modified.Observation;
import ca.ntro.ntro_app_fx_impl.modified.ObservationNtro;
import ca.ntro.ntro_core_impl.NtroCoreImpl;
import ca.ntro.ntro_core_impl.json.JsonObject;
import ca.ntro.ntro_core_impl.reflection.object_graph.ObjectGraph;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketClientNtro
extends WebSocketClient
implements MessageServer {
    private MessageFromServerHandler messageHandler = new MessageFromServerHandlerNull();
    private ObservationFromServerHandler observationHandler = new ObservationFromServerHandlerNull();

    public WebSocketClientNtro(String serverName, int port) {
        super(WebSocketClientNtro.connectionUri(serverName, port));
        NtroCore.factory().registerNamedClass(ObservationNtro.class);
    }

    private static URI connectionUri(String serverName, int port) {
        URI uri = null;
        try {
            uri = new URI(WebSocketClientNtro.connectionString(serverName, port));
        }
        catch (URISyntaxException e) {
            NtroCoreImpl.logger().fatal((Throwable)e);
        }
        return uri;
    }

    private static String connectionString(String serverName, int port) {
        return String.format("ws://%s:%d", serverName, port);
    }

    public void onOpen(ServerHandshake handshakedata) {
        Ntro.logger().info("connected to " + String.valueOf(this.getURI()));
        NtroImpl.messageService().registerMessageServer(this, DeliveryMode.CLIENT_MODE);
        this.sendRegisterSessionMessage(((Session)Ntro.session()).sessionId());
    }

    private void sendRegisterSessionMessage(String sessionId) {
        RegisterSessionImpl registerSession = new RegisterSessionImpl(sessionId);
        String messageText = NtroCoreImpl.reflection().toJsonObject((Object)registerSession).toJsonString(false);
        this.sendRawMessageToServer(messageText);
    }

    public void onMessage(String messageText) {
        NtroCore.logger().info("onMessage: " + messageText);
        try {
            JsonObject jsonObject = NtroCore.json().fromJsonString(messageText);
            ObjectGraph objectGraph = NtroCoreImpl.reflection().graphFromJsonObject(jsonObject);
            Object messageObject = NtroCoreImpl.reflection().objectFromGraph(objectGraph);
            if (messageObject instanceof MessageAbstr) {
                this.messageHandler.onMessage((MessageAbstr)messageObject);
            } else if (messageObject instanceof Observation) {
                Observation observation = (Observation)messageObject;
                Class<?> observableClass = observation.currentValue().getClass();
                String observableId = observation.id();
                this.observationHandler.onObservation(observableClass, observableId, observation);
            }
        }
        catch (Throwable t) {
            NtroCoreImpl.logger().info("onMessage: " + messageText + "\n\n");
            NtroCoreImpl.logger().fatal(t);
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        NtroCoreImpl.logger().fatal("lost connection to " + String.valueOf(this.getURI()));
    }

    public void onError(Exception ex) {
        if (ex instanceof ConnectException) {
            NtroCoreImpl.logger().fatal("failed to connect to " + String.valueOf(this.getURI()), (Throwable)ex);
        } else {
            NtroCoreImpl.logger().fatal((Throwable)ex);
        }
    }

    @Override
    public void sendMessageToServer(MessageAbstr message) {
        this.sendRawMessageToServer(NtroCoreImpl.reflection().toJsonObject((Object)message).toJsonString(false));
    }

    private void sendRawMessageToServer(String messageText) {
        this.send(messageText);
    }

    @Override
    public void broadcastMessageToOtherClients(MessageAbstr message) {
        BroadcastMessageImpl broadcastMessage = new BroadcastMessageImpl(message);
        this.send(NtroCoreImpl.reflection().toJsonObject((Object)broadcastMessage).toJsonString(false));
    }

    @Override
    public void onMessageFromServer(MessageFromServerHandler handler) {
        this.messageHandler = handler;
    }

    @Override
    public void onObservationFromServer(ObservationFromServerHandler handler) {
        this.observationHandler = handler;
    }

    @Override
    public <O extends Observable> void pushObservationToClients(Class<O> observableClass, String observableId, Observation<?> observation) {
    }

    @Override
    public <O extends Observable> void pushObservationToClients(Class<O> observableClass, Observation<?> observation) {
    }

    @Override
    public <O extends Observable> void requestFirstObservationFromServer(Class<O> observableClass, String modelId) {
        RequestFirstObservationImpl requestFirstObservationMessage = new RequestFirstObservationImpl(NtroCoreImpl.reflection().simpleName(observableClass), modelId);
        this.sendRawMessageToServer(NtroCoreImpl.reflection().toJsonObject((Object)requestFirstObservationMessage).toJsonString(false));
    }

    @Override
    public boolean areMessagesLocal() {
        return false;
    }
}

