/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.ntro_app_fx_impl.world2d.region_tree;

import ca.ntro.core.stream.Stream;
import ca.ntro.core.stream.Visitor;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.AnonymousRegion2d;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.AnonymousRegion2dNtro;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.Region2d;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.RegionName;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.RegionTree2dNode;
import ca.ntro.ntro_core_impl.stream.StreamNtro;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RegionTreeNode2dNtro<R extends Region2d>
extends AnonymousRegion2dNtro
implements RegionTree2dNode<R> {
    private Map<String, AnonymousRegion2dNtro> subRegions = new HashMap<String, AnonymousRegion2dNtro>();
    private Map<String, RegionTreeNode2dNtro<R>> subNodes = new HashMap<String, RegionTreeNode2dNtro<R>>();
    private Set<R> orphanRegions = new HashSet<R>();

    public Map<String, RegionTreeNode2dNtro<R>> getSubNodes() {
        return this.subNodes;
    }

    public void setSubNodes(Map<String, RegionTreeNode2dNtro<R>> subNodes) {
        this.subNodes = subNodes;
    }

    public Set<R> getOrphanRegions() {
        return this.orphanRegions;
    }

    public void setOrphanRegions(Set<R> orphanRegions) {
        this.orphanRegions = orphanRegions;
    }

    public RegionTreeNode2dNtro(double topLeftX, double topLeftY, double width, double height) {
        super(topLeftX, topLeftY, width, height);
        this.initializeSubRegions();
    }

    private void initializeSubRegions() {
        block6: for (RegionName regionName : RegionName.values()) {
            switch (regionName) {
                case NORTH_WEST: {
                    this.subRegions.put(RegionName.NORTH_WEST.name(), new AnonymousRegion2dNtro(this.topLeftX(), this.topLeftY(), this.width() / 2.0, this.height() / 2.0));
                    continue block6;
                }
                case NORTH_EAST: {
                    this.subRegions.put(RegionName.NORTH_EAST.name(), new AnonymousRegion2dNtro(this.topLeftX() + this.width() / 2.0, this.topLeftY(), this.width() / 2.0, this.height() / 2.0));
                    continue block6;
                }
                case SOUTH_WEST: {
                    this.subRegions.put(RegionName.NORTH_WEST.name(), new AnonymousRegion2dNtro(this.topLeftX(), this.topLeftY() + this.height() / 2.0, this.width() / 2.0, this.height() / 2.0));
                    continue block6;
                }
                case SOUTH_EAST: {
                    this.subRegions.put(RegionName.NORTH_WEST.name(), new AnonymousRegion2dNtro(this.topLeftX() + this.width() / 2.0, this.topLeftY() + this.height() / 2.0, this.width() / 2.0, this.height() / 2.0));
                }
            }
        }
    }

    @Override
    public void add(R region, double epsilon) {
        Set<String> containedIn = this.containedInSubRegions((AnonymousRegion2d)region, epsilon);
        if (containedIn.size() == 1) {
            containedIn.forEach(subNodeName -> this.addToSubNode(region, (String)subNodeName, epsilon));
        } else {
            this.addToOrphans(region);
        }
    }

    private Set<String> containedInSubRegions(AnonymousRegion2d region, double epsilon) {
        HashSet<String> containedIn = new HashSet<String>();
        for (RegionName regionName : RegionName.values()) {
            if (!region.isContainedIn(this.subRegions.get(regionName.name()), epsilon)) continue;
            containedIn.add(regionName.name());
        }
        return containedIn;
    }

    private void addToSubNode(R region, String subNodeName, double epsilon) {
        RegionTreeNode2dNtro<R> subNode = this.subNodes.get(subNodeName);
        if (subNode == null) {
            subNode = this.createSubNode(subNodeName);
        }
        subNode.add(region, epsilon);
    }

    private RegionTreeNode2dNtro<R> createSubNode(String subNodeName) {
        AnonymousRegion2dNtro subRegion = this.subRegions.get(subNodeName);
        return new RegionTreeNode2dNtro<R>(subRegion.topLeftX(), subRegion.topLeftY(), subRegion.width(), subRegion.height());
    }

    private void addToOrphans(R region) {
        this.orphanRegions.add(region);
    }

    @Override
    public void remove(R region, double epsilon) {
        Set<String> containedIn = this.containedInSubRegions((AnonymousRegion2d)region, epsilon);
        if (containedIn.size() == 1) {
            containedIn.forEach(subNodeName -> this.removeFromSubNode(region, (String)subNodeName, epsilon));
        } else {
            this.removeFromOrphans(region, epsilon);
        }
    }

    private void removeFromSubNode(R region, String subNodeName, double epsilon) {
        this.subNodes.get(subNodeName).remove(region, epsilon);
    }

    private void removeFromOrphans(R region, double epsilon) {
        HashSet<Region2d> toRemove = new HashSet<Region2d>();
        for (Region2d orphan : this.orphanRegions) {
            if (!orphan.isEqualTo((AnonymousRegion2d)region, epsilon)) continue;
            toRemove.add(orphan);
        }
        this.orphanRegions.removeAll(toRemove);
    }

    @Override
    public Stream<R> get(AnonymousRegion2d regionSpec, double epsilon) {
        Stream<R> result = null;
        Set<String> containedIn = this.containedInSubRegions(regionSpec, epsilon);
        if (containedIn.size() == 1) {
            for (String subNodeName : containedIn) {
                result = this.subNodes.get(subNodeName).get(regionSpec, epsilon);
            }
        } else {
            result = this.getFromOrphans(regionSpec, epsilon);
        }
        return result;
    }

    private Stream<R> getFromOrphans(final AnonymousRegion2d regionSpec, final double epsilon) {
        return new StreamNtro<R>(){

            public void forEach_(Visitor<R> visitor) throws Throwable {
                for (Region2d orphan : RegionTreeNode2dNtro.this.orphanRegions) {
                    if (!orphan.isEqualTo(regionSpec, epsilon)) continue;
                    visitor.visit((Object)orphan);
                }
            }
        };
    }

    @Override
    public Stream<R> get(double topLeftX, double topLeftY, double width, double height, double epsilon) {
        return this.get(new AnonymousRegion2dNtro(topLeftX, topLeftY, width, height), epsilon);
    }

    @Override
    public Stream<R> intersectWith(final AnonymousRegion2d otherRegion, final double epsilon) {
        return new StreamNtro<R>(){

            public void forEach_(Visitor<R> visitor) throws Throwable {
                for (Map.Entry<String, AnonymousRegion2dNtro> entry : RegionTreeNode2dNtro.this.subRegions.entrySet()) {
                    RegionTreeNode2dNtro subNode;
                    if (!entry.getValue().intersectsWith(otherRegion, epsilon) || (subNode = RegionTreeNode2dNtro.this.subNodes.get(entry.getKey())) == null) continue;
                    subNode.intersectWith(otherRegion, epsilon).forEach(r -> visitor.visit(r));
                }
                for (Region2d orphan : RegionTreeNode2dNtro.this.orphanRegions) {
                    if (!orphan.intersectsWith(otherRegion, epsilon)) continue;
                    visitor.visit((Object)orphan);
                }
            }
        };
    }

    @Override
    public Stream<R> intersectWith(double topLeftX, double topLeftY, double width, double height, double epsilon) {
        return this.intersectWith(new AnonymousRegion2dNtro(topLeftX, topLeftY, width, height), epsilon);
    }

    @Override
    public Stream<R> containedIn(AnonymousRegion2d otherRegion, double epsilon) {
        return new StreamNtro<R>(){

            public void forEach_(Visitor<R> visitor) throws Throwable {
            }
        };
    }

    @Override
    public Stream<R> containedIn(double topLeftX, double topLeftY, double width, double height, double epsilon) {
        return this.containedIn(new AnonymousRegion2dNtro(topLeftX, topLeftY, width, height), epsilon);
    }
}

