/*
 * Decompiled with CFR 0.152.
 */
package ca.ntro.app.world2d;

import ca.ntro.app.fx.controls.World2dMouseEventFx;
import ca.ntro.app.models.ModelValue;
import ca.ntro.app.world2d.World2dFx;
import ca.ntro.app.world2d.World2dNull;
import ca.ntro.ntro_app_fx_impl.world2d.region_tree.AnonymousRegion2d;
import javafx.scene.canvas.GraphicsContext;

public abstract class Object2dFx
implements ModelValue {
    private World2dFx world2d = new World2dNull();
    private double topLeftX;
    private double topLeftY;
    private double width;
    private double height;
    private double speedX;
    private double speedY;

    World2dFx getWorld2d() {
        return this.world2d;
    }

    public double getWorldWidth() {
        return this.world2d.getWidth();
    }

    public double getWorldHeight() {
        return this.world2d.getHeight();
    }

    public void setWorld2d(World2dFx world2d) {
        this.world2d = world2d;
    }

    public double getTopLeftX() {
        return this.topLeftX;
    }

    public void setTopLeftX(double topLeftX) {
        this.topLeftX = topLeftX;
    }

    public double getTopLeftY() {
        return this.topLeftY;
    }

    public void setTopLeftY(double topLeftY) {
        this.topLeftY = topLeftY;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getSpeedX() {
        return this.speedX;
    }

    public void setSpeedX(double speedX) {
        this.speedX = speedX;
    }

    public double getSpeedY() {
        return this.speedY;
    }

    public void setSpeedY(double speedY) {
        this.speedY = speedY;
    }

    public abstract String id();

    public abstract void initialize();

    public void initializeFx() {
    }

    public abstract void drawOnWorld(GraphicsContext var1);

    public void onTimePasses(double secondsElapsed) {
        this.topLeftX += this.speedX * secondsElapsed;
        this.topLeftY += this.speedY * secondsElapsed;
    }

    public boolean collidesWith(Object2dFx other) {
        return other.collidesWith(this.topLeftX, this.topLeftY, this.width, this.height);
    }

    public boolean collidesWith(double topLeftX, double topLeftY, double width, double height) {
        return this.collidesOneAxis(this.topLeftX, this.width, topLeftX, width) && this.collidesOneAxis(this.topLeftY, this.height, topLeftY, height);
    }

    private boolean collidesOneAxis(double coord1, double size1, double coord2, double size2) {
        return coord1 < coord2 && coord1 + size1 >= coord2 || coord2 <= coord1 && coord2 + size2 >= coord1;
    }

    protected abstract boolean onMouseEvent(World2dMouseEventFx var1);

    public void copyDataFrom(Object2dFx object2d) {
        this.setTopLeftX(object2d.getTopLeftX());
        this.setTopLeftY(object2d.getTopLeftY());
        this.setWidth(object2d.getWidth());
        this.setHeight(object2d.getHeight());
        this.setSpeedX(object2d.getSpeedX());
        this.setSpeedY(object2d.getSpeedY());
    }

    public boolean isContainedIn(AnonymousRegion2d otherRegion, double epsilon) {
        return this.isContainedIn(otherRegion.topLeftX(), otherRegion.topLeftY(), otherRegion.width(), otherRegion.height(), epsilon);
    }

    public boolean isContainedIn(double topLeftX, double topLeftY, double width, double height, double epsilon) {
        return AnonymousRegion2d.isContainedIn(this.topLeftX, this.topLeftY, this.width, this.height, topLeftX, topLeftY, width, height, epsilon);
    }

    public boolean intersectsWith(AnonymousRegion2d otherRegion, double epsilon) {
        return this.intersectsWith(otherRegion.topLeftX(), otherRegion.topLeftY(), otherRegion.width(), otherRegion.height(), epsilon);
    }

    public boolean intersectsWith(double topLeftX, double topLeftY, double width, double height, double epsilon) {
        return AnonymousRegion2d.intersectsWith(this.topLeftX, this.topLeftY, this.width, this.height, topLeftX, topLeftY, width, height, epsilon);
    }

    public boolean isEqualTo(AnonymousRegion2d otherRegion, double epsilon) {
        return this.isEqualTo(otherRegion.topLeftX(), otherRegion.topLeftY(), otherRegion.width(), otherRegion.height(), epsilon);
    }

    public boolean isEqualTo(double topLeftX, double topLeftY, double width, double height, double epsilon) {
        return AnonymousRegion2d.isEqualTo(this.topLeftX, this.topLeftY, this.width, this.height, topLeftX, topLeftY, width, height, epsilon);
    }
}

